/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ContextMenu
implements Part {
    private ArrayList items = new ArrayList();
    private ArrayList swtItems = new ArrayList();
    private Object currentObject = null;
    private ContextMenu parent = null;
    private Menu menu = null;
    private String name = null;
    private Image image = null;

    public void addItem(ContextMenuItem item) {
        if (item != null) {
            this.items.add(item);
        }
    }

    public List getItems() {
        return this.items;
    }

    public void addMenu(ContextMenu menu) {
        if (menu != null) {
            this.items.add(menu);
        }
    }

    public void setText(String text) {
        if (text != null && text.length() > 0) {
            this.name = text;
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        if (this.swtItems.size() > 0) {
            return;
        }
        if (this.parent != null) {
            if (this.name == null || this.name.length() == 0) {
                Logger.warn((String)"menu defined as sub menu but contains no name");
                return;
            }
            MenuItem i = new MenuItem(this.parent.menu, 64);
            i.setText(this.name);
            if (this.image != null) {
                i.setImage(this.image);
            }
            this.menu = new Menu((Decorations)parent.getShell(), 4);
            i.setMenu(this.menu);
        } else {
            this.menu = new Menu((Decorations)parent.getShell(), 8);
            parent.setMenu(this.menu);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            Object o = this.items.get(i);
            if (o instanceof ContextMenu) {
                ContextMenu sub = (ContextMenu)o;
                sub.parent = this;
                sub.paint(parent);
                this.swtItems.add(sub);
                continue;
            }
            final ContextMenuItem item = (ContextMenuItem)o;
            if (item.isSeparator()) {
                this.swtItems.add(new MenuItem(this.menu, 2));
                continue;
            }
            String text = item.getText();
            if (text == null || text.length() == 0) continue;
            MenuItem mi = new MenuItem(this.menu, 8);
            this.updateText(item, mi);
            Image image = item.getImage();
            if (image != null) {
                mi.setImage(image);
            }
            mi.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Action a = item.getAction();
                    if (a == null) {
                        return;
                    }
                    try {
                        a.handleAction(ContextMenu.this.currentObject);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                    }
                    catch (ApplicationException e) {
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(e.getMessage(), 1));
                    }
                }
            });
            this.swtItems.add(mi);
        }
    }

    protected void setCurrentObject(Object object) {
        this.currentObject = object;
        Object o = null;
        Object mi = null;
        for (int i = 0; i < this.swtItems.size(); ++i) {
            o = this.items.get(i);
            mi = this.swtItems.get(i);
            if (o == null || mi == null) continue;
            if (o instanceof ContextMenu) {
                ((ContextMenu)o).setCurrentObject(object);
                continue;
            }
            ContextMenuItem ci = o;
            MenuItem m = mi;
            m.setEnabled(ci.isEnabledFor(object));
            this.updateText(ci, m);
        }
    }

    private void updateText(ContextMenuItem ci, MenuItem mi) {
        if (ci == null || ci.isSeparator() || mi == null || mi.isDisposed()) {
            return;
        }
        Object text = ci.getText();
        if (text == null || ((String)text).length() == 0) {
            return;
        }
        String shortcut = ci.getShortcut();
        if (shortcut != null) {
            try {
                KeyStroke stroke = KeyStroke.getInstance((String)shortcut);
                if (stroke.isComplete()) {
                    text = (String)text + "\t" + SWTKeySupport.getKeyFormatterForPlatform().format(stroke);
                }
            }
            catch (Exception e) {
                Logger.error((String)("unable to parse shortcut " + shortcut), (Throwable)e);
            }
        }
        mi.setText((String)text);
    }
}

